﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;

 
namespace Lessons.Workflows
{
    class Program
    {
        static void Main(string[] args)
        {
 
            using (WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);

 
                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e) { waitHandle.Set(); };
                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };
                
 
                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();
 
                waitHandle.WaitOne();

                Console.WriteLine("Hit <ENTER> key to exit");
                Console.ReadLine();
            }
        }
    }
}
